<?php

namespace App\Http\Controllers;

use App\Models\BannerModel;
use Illuminate\Http\Request;

class BannerController extends Controller
{
    private $banner_path = "uploads/banners";

    public function add_banner_view()
    {
        $banners = BannerModel::all();
        return view("banners.add_banner", compact('banners'));
    }

    public function edit_banner($id)
    {
        $banner =  BannerModel::find($id);
        if ($banner) {
            return view("banners.edit_banner", compact('banner'));
        }
        return redirect(route("add.banner"))->with("error", "Sorry requested data not found");
    }
    public function saveBanner(Request $request)
    {
        $validation = $request->validate([
            'heading' => 'required|string',
            'short_details' => 'required|string',
            'image_banner' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        $imageName = time() . '.' . $request->image_banner->extension();
        $request->image_banner->move(public_path($this->banner_path), $imageName);
        $banner = new BannerModel();
        $banner->heading = $request->heading;
        $banner->short_details = $request->short_details;
        $banner->image = $this->banner_path . "/" . $imageName;
        $banner->save();
        return redirect(route("add.banner"))->with("success", "Banner added successfully");
    }

    public function updateBanner(Request $request)
    {

        $data = array(
            'heading' => 'required|string',
            'id' => 'required|integer',
            'short_details' => 'required|string',
        );

        if ($request->image_banner) {
            $data["image_banner"] = 'required|image|mimes:jpeg,png,jpg,gif|max:2048';
        }

        $validation = $request->validate($data);


        $banner = BannerModel::find($request->id);
        if (!$banner) {
            return redirect(route("add.banner"))->with("error", "Sorry requested data not found");
        }

        if ($request->image_banner) {
            $imageName = time() . '.' . $request->image_banner->extension();
            $request->image_banner->move(public_path($this->banner_path), $imageName);
            $banner->image = $this->banner_path . "/" . $imageName;
        }

        $banner->heading = $request->heading;
        $banner->short_details = $request->short_details;
        $banner->save();
        return redirect(route("add.banner"))->with("success", "Banner updated successfully");
    }


    public function delete($id){

        $banner = BannerModel::find($id);
        if (!$banner) {
            return redirect(route("add.banner"))->with("error", "Sorry requested data not found");
        }

        $banner->delete();
        return redirect(route("add.banner"))->with("success", "Banner deleted successfully");

    }



    // public  function list_banner_view(){
    //     return view("banners.list_banner");

    // }
}
