<?php

namespace App\Http\Controllers;

use App\Models\FaqModel;
use Illuminate\Http\Request;

class FaqController extends Controller
{
    public function add_faq_view(){
        return view("faq.add_faq");
    }

    public function list_faq_view(){
        $faqs = FaqModel::orderBy("id","DESC")->get();
        return view("faq.list_faq",compact('faqs'));
    }

    public function edit($id){
        $faq = FaqModel::where("id",$id)->first();
        if(!$faq){
            return redirect(route("list.faq"))->with("sorry", "Sorry data not found");
        }

        return view("faq.edit_faq",compact('faq'));
    }

    public function saveFaq(Request $request)
    {
        $validation = $request->validate([
            'question' => 'required|string',
            'answer' => 'required|string',
        ]);

        $faq = new FaqModel();
        $faq->question = $request->question;
        $faq->answer = $request->answer;
        $faq->save();
        return redirect(route("add.faq"))->with("success", "FAQ added successfully");
    }


    public function updateFaq(Request $request)
    {
        $validation = $request->validate([
            'id' => 'required|integer',
            'question' => 'required|string',
            'answer' => 'required|string',
        ]);

        $faq = FaqModel::where("id",$request->id)->first();
        if(!$faq){
            return redirect(route("list.faq"))->with("sorry", "Sorry data not found");
        }


        $faq->question = $request->question;
        $faq->answer = $request->answer;
        $faq->save();
        return redirect(route("list.faq"))->with("success", "FAQ updated successfully");
    }

    public function delete($id){
        $faq = FaqModel::where("id",$id)->delete();
        return redirect(route("list.faq"))->with("success", "FAQ deleted successfully");

    }

}
