<?php

namespace App\Http\Controllers;

use App\Models\FeatureModel;
use Illuminate\Http\Request;

class FeaturesController extends Controller
{
    private $banner_path = "uploads/features";

    public function add_feature_view()
    {
        return view("features.add_f");
    }
    public function list_feature_view()
    {
        $features = FeatureModel::all();
        return view("features.list_f", compact('features'));
    }


    public function edit_feature($id)
    {
        $feature =  FeatureModel::find($id);
        if ($feature) {
            return view("features.edit_f", compact('feature'));
        }
        return redirect(route("add.features"))->with("error", "Sorry requested data not found");
    }
    public function saveFeature(Request $request)
    {
        $validation = $request->validate([
            'heading' => 'required|string',
            'short_details' => 'required|string',
            'image_banner' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        $imageName = time() . '.' . $request->image_banner->extension();
        $request->image_banner->move(public_path($this->banner_path), $imageName);
        $banner = new FeatureModel();
        $banner->heading = $request->heading;
        $banner->short_details = $request->short_details;
        $banner->image = $this->banner_path . "/" . $imageName;
        $banner->save();
        return redirect(route("add.features"))->with("success", "Feature added successfully");
    }

    public function updateFeature(Request $request)
    {

        $data = array(
            'heading' => 'required|string',
            'id' => 'required|integer',
            'short_details' => 'required|string',
        );

        if ($request->image_banner) {
            $data["image_banner"] = 'required|image|mimes:jpeg,png,jpg,gif|max:2048';
        }

        $validation = $request->validate($data);


        $banner = FeatureModel::find($request->id);
        if (!$banner) {
            return redirect(route("list.features"))->with("error", "Sorry requested data not found");
        }

        if ($request->image_banner) {
            $imageName = time() . '.' . $request->image_banner->extension();
            $request->image_banner->move(public_path($this->banner_path), $imageName);
            $banner->image = $this->banner_path . "/" . $imageName;
        }

        $banner->heading = $request->heading;
        $banner->short_details = $request->short_details;
        $banner->save();
        return redirect(route("list.features"))->with("success", "Feature updated successfully");
    }


    public function delete($id){

        $banner = FeatureModel::find($id);
        if (!$banner) {
            return redirect(route("list.features"))->with("error", "Sorry requested data not found");
        }

        $banner->delete();
        return redirect(route("list.features"))->with("success", "Feature deleted successfully");

    }



}
