<?php

namespace App\Http\Controllers;

use App\Models\EventModels;
use Illuminate\Http\Request;

class NewsController extends Controller
{

    private  $event_path = "uploads/news";

    public function add_event_view()
    {
        $heading = "Add News";
        $type = "news";
        return view("events.add_event",compact('heading','type'));
    }

    public function list_event_view()
    {
        $heading = "News List";
        $events =  EventModels::orderBy("id", "DESC")->where("type","news")->get();
        return view("events.list_event", compact('events'));
    }
    public function addEvent(Request $request)
    {

        $validation = $request->validate([
            'heading' => 'required|string',
            'type' => 'required|string',
            'short_details' => 'required|string',
            'image_banner' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'event_date' => 'required|string',
            'full_details' => 'required|string',
        ]);


        $imageName = time() . '.' . $request->image_banner->extension();
        $request->image_banner->move(public_path($this->event_path), $imageName);
        $events = new EventModels();
        $events->heading = $request->heading;
        $events->short_details = $request->short_details;
        $events->event_date = $request->event_date;
        $events->details = $request->full_details;
        $events->type = $request->type;
        $events->display_image = $this->event_path . "/" . $imageName;
        $events->save();


        return redirect(route("list.events"))->with("success", "Event added successfully");
    }
}
