<?php

namespace App\Http\Controllers;

use App\Models\ServiceModel;
use Illuminate\Http\Request;

class ServicesController extends Controller
{
    public function add_service_view(){
        return view("serevices.add_service");
    }
    public function list_service_view(){
        $services = ServiceModel::orderBy("id","DESC")->get();
        return view("serevices.list_service",compact('services'));
    }

    public function addService(Request $request){
        $validation = $request->validate([
            'heading' => 'required|string',
            'short_details' => 'required|string',
            'full_details' => 'required',
        ]);

        $service = new ServiceModel();
        $service->heading = $request->heading;
        $service->short_details = $request->short_details;
        $service->details = $request->full_details;
        $service->save();

        return redirect(route("add.service"))->with("success", "Service added successfully");

    }
    

    
    public function edit_service($id)
    {
        $service =  ServiceModel::find($id);
        if ($service) {
            return view("serevices.edit_service", compact('service'));
        }
        return redirect(route("add.service"))->with("error", "Sorry requested data not found");
    }


    public function updateService(Request $request)
    {

        $data = array(
            'heading' => 'required|string',
            'id' => 'required|integer',
            'full_details' => 'required|string',
            "short_details"=> 'required|string',
        );
      
        $validation = $request->validate($data);

        $banner = ServiceModel::find($request->id);
        
        $banner->heading = $request->heading;
        $banner->short_details = $request->short_details;
        $banner->details = $request->full_details;
        $banner->save();

        return redirect(route("list.service"))->with("success", "Service updated successfully");

    }

    public function delete($id){

        $service = ServiceModel::find($id);
        if (!$service) {
            return redirect(route("list.service"))->with("error", "Sorry requested data not found");
        }

        $service->delete();
        return redirect(route("list.service"))->with("success", "Service deleted successfully");

    }

}
