<?php

namespace App\Http\Controllers;

use App\Models\TestimonialsModel;
use Illuminate\Http\Request;

class TestimonialsController extends Controller
{

    private $banner_path = "uploads/testimonials";

    public function add_client_view()
    {
        return view("testimonials.add_clients");
    }

    public function edit($id)
    {
        $client = TestimonialsModel::find($id);
        if (!$client) {
            return redirect(route("list.client"))->with("error", "Sorry result not found");
        }
        return view("testimonials.edit_client", compact('client'));
    }
    public function list_client_view()
    {
        $clients = TestimonialsModel::where("type","testimonial")
        ->orderBy("id", "DESC")->get();
        return view("testimonials.list_clients", compact('clients'));
    }

    public function saveClient(Request $request)
    {
        $validation = $request->validate([
            'client_name' => 'required|string',
            'job_post' => 'required|string',
            'short_details' => 'required|string',
            'profile_image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);


        $imageName = time() . '.' . $request->profile_image->extension();
        $request->profile_image->move(public_path($this->banner_path), $imageName);
        $client = new TestimonialsModel();
        $client->client_name = $request->client_name;
        $client->client_post = $request->job_post;
        $client->client_message = $request->short_details;
        $client->type = "testimonial";
        $client->image = $this->banner_path . "/" . $imageName;
        $client->save();
        return redirect(route("add.client"))->with("success", "Testimonial added successfully");
    }

    public function updateClient(Request $request)
    {
        $data  = array(
            'id' => 'required|integer',
            'client_name' => 'required|string',
            'job_post' => 'required|string',
            'short_details' => 'required|string',

        );

        if ($request->profile_image) {
            $data["profile_image"] = 'required|image|mimes:jpeg,png,jpg,gif|max:2048';
        }

        $validation = $request->validate($data);


        $client = TestimonialsModel::find($request->id);

        if (!$client) {
            return redirect(route("list.client"))->with("error", "Sorry requested data not found");
        }

        if ($request->profile_image) {
            $imageName = time() . '.' . $request->profile_image->extension();
            $request->profile_image->move(public_path($this->banner_path), $imageName);
            $client->image = $this->banner_path . "/" . $imageName;
        }

        $client->client_name = $request->client_name;
        $client->client_post = $request->job_post;
        $client->client_message = $request->short_details;
        $client->save();
        return redirect(route("list.client"))->with("success", "Testimonial updated successfully");
    }

    public function deleteTestimonial($id){
        TestimonialsModel::where("id",$id)->delete();
        return redirect(route("list.client"))->with("success", "Testimonial deleted successfully");
    }

}
