<?php

namespace App\Http\Controllers;

use App\Models\VideosModel;
use Illuminate\Http\Request;

class VideosController extends Controller
{
    public function add_video_view()
    {
        return view("videos.add_videos");
    }

    public function all_videos(){
        $videos =  VideosModel::orderBy("id","DESC")->get();
        return view("videos.list_videos",compact('videos'));
    }

    public function addVideo(Request $request)
    {

        $validation =  $request->validate([
            'video_url' => "required|string"
        ]);

        $videomodel = new VideosModel();
        $videomodel->video_url = $request->video_url;
        $videomodel->save();
        return redirect(route("add.videos"))->with("success", "Video added successfully");
    }

    public function edit($id)
    {
        $video = VideosModel::find($id);
        if (!$video) {
            return redirect(route("list.videos"))->with(
                "error",
                "Sorry video not found"
            );
        }

        return   view("videos.edit_videos", compact('video'));
    }
    public function updateVideo(Request $request)
    {
        $validation =  $request->validate([
            'video_url' => "required|string",
            'id' => "required|integer"
        ]);
        $videomodel = VideosModel::find($request->id);
        if (!$videomodel) {
            return redirect(route("list.videos"))->with(
                "error",
                "Sorry video not found"
            );
        }

        $videomodel->video_url = $request->video_url;
        $videomodel->save();
        return redirect(route("list.videos"))->with("success", "Video updated successfully");
    }

    public function deleteVideo($id){
        $videomodel = VideosModel::where("id",$id)->delete();
        return redirect(route("list.videos"))->with("success", "Video deleted successfully");
    }
}
