@extends('layouts.master')
@section('content')
    <div class="col-lg-12">
        <div class="white_card card_height_100 mb_30">
            <div class="white_card_header">
                <div class="box_header m-0">
                    <div class="main-title">
                        <h3 class="m-0">Add Banner</h3>
                    </div>
                </div>
            </div>

            <div class="white_card_body">
                <div class="card-body">
                    <form method="POST" action="{{ route('save.banner') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label" for="heading">Heading</label>
                                <input type="text" name="heading" required class="form-control" id="heading"
                                    placeholder="Enter Heading">
                            </div>
                            <div class=" col-md-6">
                                <label class="form-label" for="short_details">Short Details</label>
                                <input type="text" name="short_details" required class="form-control" id="short_details"
                                    placeholder="Short Details">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label" for="inputAddress">Select Banner Image</label>
                            <input type="file" name="image_banner" required class="form-control" id="inputAddress">
                        </div>

                        <button type="submit" class="btn btn-primary">Add Banner</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-12">
        <div class="white_card card_height_100 mb_30">
            <div class="white_card_header">
                <div class="box_header m-0">
                    <div class="main-title">
                        <h3 class="m-0">Banners Lists</h3>
                    </div>
                </div>
            </div>
            <div class="white_card_body">
                <div class="QA_section">
                    <div class="QA_table mb_30">

                        <table class="table lms_table_active ">
                            <thead>
                                <tr>
                                    <th scope="col">ID</th>
                                    <th scope="col">Heading</th>
                                    <th scope="col">Short Details</th>
                                    <th scope="col">Image</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if ($banners)
                                    @foreach ($banners as $index => $list)
                                        <tr>
                                            <th scope="row"> <a href="#"
                                                    class="question_content">{{ ++$index }}</a></th>
                                            <td>{{ $list->heading }}</td>
                                            <td>{{ $list->short_details }}</td>
                                            <td>
                                                <img style="width: 100px;" src="{{ asset($list->image) }}" />

                                            </td>
                                            <td>
                                                <div class="action_btns d-flex">
                                                    <a href="{{ route('edit.banner', $list->id) }}"
                                                        class="action_btn mr_10 "> <i class="far fa-edit"></i>
                                                    </a>
                                                    <a href="javascript::void()"
                                                    onclick="deleteBanner({{$list->id}})"  class="action_btn"> <i class="fas fa-trash"></i> </a>
                                                </div>
                                            </td>

                                        </tr>
                                    @endforeach
                                @endif

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function deleteBanner(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                   window.location.href = "{{url('/delete/banner')}}/"+id;
                }
            })
        }
    </script>
@endsection
