@extends('layouts.master')
@section('content')

    <div class="col-lg-12">
        <div class="white_card card_height_100 mb_30">
            <div class="white_card_header">
                <div class="box_header m-0">
                    <div class="main-title">
                        <h3 class="m-0">Services Lists</h3>
                    </div>
                </div>
            </div>
            <div class="white_card_body">
                <div class="QA_section">
                    <div class="QA_table mb_30">

                        <table class="table lms_table_active ">
                            <thead>
                                <tr>
                                    <th scope="col">ID</th>
                                    <th scope="col">Heading</th>
                                    <th scope="col">Short Details</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if ($services)
                                    @foreach ($services as $index => $list)
                                        <tr>
                                            <th scope="row"> <a href="#"
                                                    class="question_content">{{ ++$index }}</a></th>
                                            <td>{{ $list->heading }}</td>
                                            <td>{{ $list->short_details }}</td>
                                           
                                            <td>
                                                <div class="action_btns d-flex">
                                                    <a href="{{ route('edit.service', $list->id) }}"
                                                        class="action_btn mr_10 "> <i class="far fa-edit"></i>
                                                    </a>
                                                    <a href="javascript::void()" onclick="deleteService({{ $list->id }})"
                                                        class="action_btn"> <i class="fas fa-trash"></i> </a>
                                                </div>
                                            </td>

                                        </tr>
                                    @endforeach
                                @endif

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function deleteService(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{ url('delete/service') }}/" + id;
                }
            })
        }
    </script>
@endsection
