@extends('layouts.master')
@section('content')
    <div class="col-lg-12">
        <div class="white_card card_height_100 mb_30">
            <div class="white_card_header">
                <div class="box_header m-0">
                    <div class="main-title">
                        <h3 class="m-0">Update Project</h3>
                    </div>
                </div>
            </div>
            <div class="white_card_body">
                <div class="card-body">
                    <form method="POST" action="{{ route('save.project') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label" for="heading_one">Heading </label>
                                <input type="text" required name="heading" class="form-control" id="heading_one"
                                    placeholder="Enter Title">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label" for="value_two">Heading Value</label>
                                <input type="text" required name="heading_value" class="form-control" id="heading_value"
                                    placeholder="Enter Job Post">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label" for="icons">Icons</label>
                                <input type="file" required name="icon" class="form-control" id="icon">
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12">
        <div class="white_card card_height_100 mb_30">
            <div class="white_card_header">
                <div class="box_header m-0">
                    <div class="main-title">
                        <h3 class="m-0">Projects Lists</h3>
                    </div>
                </div>
            </div>
            <div class="white_card_body">
                <div class="QA_section">
                    <div class="QA_table mb_30">

                        <table class="table lms_table_active ">
                            <thead>
                                <tr>
                                    <th scope="col">ID</th>
                                    <th scope="col">Heading</th>
                                    <th scope="col">Heading Value</th>
                                    <th scope="col">Icon</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if ($project)
                                    @foreach ($project as $index => $list)
                                        <tr>
                                            <th scope="row"> <a href="#"
                                                    class="question_content">{{ ++$index }}</a></th>
                                            <td>{{ $list->heading }}</td>
                                            <td>{{ $list->heading_value }}</td>
                                            <td style=" text-align: center; background: #ff5d00;">
                                                <img style="height:100px;width:100px;" src="{{ asset($list->icon) }}" />
                                            </td>

                                            <td>
                                                <div class="action_btns d-flex">
                                                    <a href="{{ route('edit.project', $list->id) }}"
                                                        class="action_btn mr_10 "> <i class="far fa-edit"></i>
                                                    </a>
                                                    <a href="javascript::void()"
                                                        onclick="deleteProject({{ $list->id }})" class="action_btn">
                                                        <i class="fas fa-trash"></i> </a>
                                                </div>
                                            </td>

                                        </tr>
                                    @endforeach
                                @endif

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function deleteProject(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{ url('project/delete/') }}/" + id;
                }
            })
        }
    </script>
@endsection
