
<?php $__env->startSection('content'); ?>
    <div class="col-lg-12">
        <div class="white_card card_height_100 mb_30">
            <div class="white_card_header">
                <div class="box_header m-0">
                    <div class="main-title">
                        <h3 class="m-0">Update Project</h3>
                    </div>
                </div>
            </div>
            <div class="white_card_body">
                <div class="card-body">
                    <form method="POST" action="<?php echo e(route('save.project')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label" for="heading_one">Heading </label>
                                <input type="text" required name="heading" class="form-control" id="heading_one"
                                    placeholder="Enter Title">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label" for="value_two">Heading Value</label>
                                <input type="text" required name="heading_value" class="form-control" id="heading_value"
                                    placeholder="Enter Job Post">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label" for="icons">Icons</label>
                                <input type="file" required name="icon" class="form-control" id="icon">
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12">
        <div class="white_card card_height_100 mb_30">
            <div class="white_card_header">
                <div class="box_header m-0">
                    <div class="main-title">
                        <h3 class="m-0">Projects Lists</h3>
                    </div>
                </div>
            </div>
            <div class="white_card_body">
                <div class="QA_section">
                    <div class="QA_table mb_30">

                        <table class="table lms_table_active ">
                            <thead>
                                <tr>
                                    <th scope="col">ID</th>
                                    <th scope="col">Heading</th>
                                    <th scope="col">Heading Value</th>
                                    <th scope="col">Icon</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if($project): ?>
                                    <?php $__currentLoopData = $project; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row"> <a href="#"
                                                    class="question_content"><?php echo e(++$index); ?></a></th>
                                            <td><?php echo e($list->heading); ?></td>
                                            <td><?php echo e($list->heading_value); ?></td>
                                            <td style=" text-align: center; background: #ff5d00;">
                                                <img style="height:100px;width:100px;" src="<?php echo e(asset($list->icon)); ?>" />
                                            </td>

                                            <td>
                                                <div class="action_btns d-flex">
                                                    <a href="<?php echo e(route('edit.project', $list->id)); ?>"
                                                        class="action_btn mr_10 "> <i class="far fa-edit"></i>
                                                    </a>
                                                    <a href="javascript::void()"
                                                        onclick="deleteProject(<?php echo e($list->id); ?>)" class="action_btn">
                                                        <i class="fas fa-trash"></i> </a>
                                                </div>
                                            </td>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function deleteProject(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "<?php echo e(url('project/delete/')); ?>/" + id;
                }
            })
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\erate\resources\views/team/project.blade.php ENDPATH**/ ?>